/** @file   FileHasher.h
 * @brief   Declaration of FileHasher - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */
 

#ifndef H_ENG2D_FILEHASHER_H
#define H_ENG2D_FILEHASHER_H

#include "eng2d_dll.h"
#include <string>


namespace eng2d {


/** @class  FileHasher
 * @brief   Checks and sets the hashcodes to files to gain integrity checks.
 * @author  Tomi Lamminsaari
 *
 * FileHasher -class sets or retrieves the file's hashcode. We need
 * the hashcode to provide simple protection agains hacking the
 * savefiles.
 *
 * The savefiles are plain ASCII-files. The last line of the files should
 * have <code>[END]</code> as its content. This class uses all the contents
 * before that "tag" to calculate a hash-value and it will be saved to the
 * line after the <code>[END]</code> - tag.
 */
class DLLIMPORT FileHasher
{
public:

  ///
  /// Static members and methods
  /// ==========================
  
  /** Datatype for hash-values */
  typedef long HashNum;
  

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Constructs new file hasher.
   * @param     filename          Name of the file you want to play with.
   */
  FileHasher( const std::string& filename );
  
  /** Copy constructor
   */
  FileHasher(const FileHasher& rO);
  /** Destructor.
   */
  ~FileHasher();
  /** Operator =
   */
  FileHasher& operator = (const FileHasher& rO);


  ///
  /// Public methods
  /// ==============
  
  /** Inserts the hashcode at the end of the file that was given to the
   * constructor.
   */
  void set();
  


  ///
  /// Getter-methods
  /// ==============
  
  /** Checks the validity of the hashcode from file you gave to the constructor.
   * If the file cannot be opened, this returns @c false
   * @return    <code>true</code> if hashcode if INVALID.
   */
  bool check() const;
  

protected:

  /** Private methods **/

  /** Calculates the hashvalue for the file this object is attached to.
   * @return    The hashvalue.
   */
  HashNum hash() const;



  ///
  /// Members
  /// =======

  /** Name of the file */
  std::string m_filename;
};


};  // end of namespace

#endif
